// The application shows text field for URL, webview, and simple toobar
import QtQuick 1.1
import QtWebKit 1.1
import Sailfish.Silica 1.0

ApplicationWindow {
    id: window

    initialPage: Page {
        // We use column to position the url field, webview, and toolbar
        Column {
            anchors.fill: parent

            TextField {
                id: urlField
                text: "http://jolla.com/"
                width: parent.width

                // When return is pressed url is set to the WebView and focus is
                // taken away from textfield which closes the virtual keyboard
                Keys.onReturnPressed: {
                    webView.url = text
                    webView.forceActiveFocus()
                }
            }

            // Flickable allows user to pan an element that is bigger than
            // display area available, in this case the webview is the size of
            // the web content, and flickable allows user to pan the webview if
            // the area of webview is bigger than screen area available
            SilicaFlickable {
                // Fill the height
                height: parent.height - (urlField.height + toolBar.height)
                width: window.width
                clip: true

                // content size is the size that user can pan around
                contentWidth: webView.width
                contentHeight: webView.height

                WebView {
                    id: webView
                    width: window.width
                    preferredWidth: window.width
                    preferredHeight: parent.height
                    url: "http://jolla.com/"

                    // When clicks link url changes
                    // this updates the text in the urlField in that case
                    onUrlChanged: urlField.text = url
                }
            }

            // Toolbar is just buttons in a row
            Row {
                id: toolBar
                // space between the buttons
                spacing: theme.paddingLarge
                anchors.horizontalCenter: parent.horizontalCenter

                IconButton {
                    icon.source: "image://theme/icon-m-back"
                    enabled: webView.back.enabled
                    onClicked: webView.back.trigger()
                }
                IconButton {
                    icon.source: "image://theme/icon-m-reset"
                    enabled: webView.stop.enabled
                    onClicked: webView.stop.trigger()
                }
                IconButton {
                    icon.source: "image://theme/icon-m-refresh"
                    enabled: webView.reload.enabled
                    onClicked: webView.reload.trigger()
                }
                IconButton {
                    icon.source: "image://theme/icon-m-forward"
                    enabled: webView.forward.enabled
                    onClicked: webView.forward.trigger()
                }
            }
        }
    }
}

